﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Net;
using System.Web;
using System.Threading;

namespace CS_iSMS_Tester
{
    class HTTPServer
    {
        private HttpListener iSMS_HTTP_listener; // .NET class used to create HTTP server.
        private Thread listenThread; // Used to create new thread, so current thread doesn't hang.
        public EventArgs e = null; // Blank event arguement.
        public delegate void MsgHandler(); //String serverProtocol); //, EventArgs e); // Delegate is used to make call back function.
        public event MsgHandler MsgAlert;
        private bool Running = false; // Tracks whether server should be running.
        public String iSMSresponse = "";
        public bool iso_enabled = false;
        
        

        // Constructor creates a new HTTP listener class
        public HTTPServer()
        {
            iSMS_HTTP_listener = new HttpListener();
        }

        // Start HTTP Server
        public void Start(string uriPrefix)
        {

            try
            {
                // Clear any previous hostname/port, incase settings have changed.
                iSMS_HTTP_listener.Prefixes.Clear();
                // Set uriPrefix with new hostname/port
                iSMS_HTTP_listener.Prefixes.Add(uriPrefix);
                Running = true; // Set flag as running
                // Create new thread to listen for HTTP request from. 
                // Otherwise the current thread will hang while waiting for connections.
                this.listenThread = new Thread(new ThreadStart(ListenForClients));
                this.listenThread.Start();
            }
            catch
            {
                Console.WriteLine("Error starting listener.");
            }
        }


        // Listen for HTTP requests
        private void ListenForClients()
        {
            try
            {
                iSMS_HTTP_listener.Start();
            }
            catch
            {
                Console.WriteLine("Error starting HTTP listener.");
            }
            // Continue listening for HTTP requests until Running is set to false.
            while (Running)
                try {
                    HttpListenerContext request = iSMS_HTTP_listener.GetContext();
                    ThreadPool.QueueUserWorkItem(ProcessRequest, request);
                } catch (HttpListenerException) { break; }  
                catch (InvalidOperationException) { break; }
        }


        // Process a received HTTP request
        private void ProcessRequest(object listenerContext) {
            try 
            {
                var context = (HttpListenerContext)listenerContext; // Request info held in context.
                Stream clientStream = context.Request.InputStream; // Get stream to read request from. 
                //ASCIIEncoding utf8_encoder = new ASCIIEncoding();
                Encoding encoder;                
                Console.WriteLine("Using ISO-8859-1 to decode.");
                encoder = System.Text.Encoding.GetEncoding(28591); // new System.Text.Encoding.GetEncoding(28591)();
                
                byte[] message = new byte[6000];
                int bytesRead;
                String ThreadMsg=""; // Holds raw string with XML data encoded.
                String DecodedMsg = ""; // Holds XML data after decoded

                // Read from request stream one chunk at time until all data is read.
                while (true)
                {
                    bytesRead = 0;
                    try
                    { bytesRead = clientStream.Read(message, 0, 4096); }
                    catch
                    { break; } //a socket error has occured

                    if (bytesRead == 0)
                        break; //the client has disconnected from the server
                    
                    System.Diagnostics.Debug.WriteLine(encoder.GetString(message, 0, bytesRead));
                    ThreadMsg = ThreadMsg + encoder.GetString(message, 0, bytesRead); // Add this chunk to ThreadMsg string.
                }
                //message has successfully been received
                
                // Remove special encoding (spaces=%20 ect...)
                Console.WriteLine("Encoded message(RCV): " + ThreadMsg);
                DecodedMsg = HttpUtility.UrlDecode(ThreadMsg, System.Text.Encoding.GetEncoding("iso-8859-1"));
                Console.WriteLine("Decoded message: " + DecodedMsg);
              
                // Send back OK to iSMS
                context.Response.StatusCode = (int)HttpStatusCode.OK;
                byte[] msg = encoder.GetBytes("OK");
                context.Response.ContentLength64 = msg.Length;
                using (Stream s = context.Response.OutputStream)
                    s.Write(msg, 0, msg.Length);
                iSMSresponse = DecodedMsg;

                // Call the function set a the Message Handler. If it has been set.
                if (MsgAlert != null)
                {
                    MsgAlert.Invoke(); //"HTTP"); //, e);
                }
            } catch (Exception ex) { Console.WriteLine("Request error: " + ex); }
        }


        // Set the function passed to SetEventHandler as the function to be called when a request is received.
        public void SetEventHandler(MsgHandler MsgHandlerFunc)
        {
            this.MsgAlert += new MsgHandler(MsgHandlerFunc);
        }


        // Shutdown Server
        public void CloseServer()
        {
            Running = false; // Stops listener function from trying to listen after server stopped.
            try
            {
                if (iSMS_HTTP_listener != null) iSMS_HTTP_listener.Stop();
            }
            catch
            {
                Console.WriteLine("Error stopping HTTP listener.");
            }
        }
    }
}
